*-------------------------------------------------------------------------------
/* title : Find capital/labor intensive industries (KL)
   source: WIOD, Socio Economic Accounts Release 2016
		   http://www.wiod.org/database/seas16; File: All countries (excel file)
   input : $temp/Sample.dta and $temp/Selection_criteria.dta
   output: see industry splits at Stata output window*/
*-------------------------------------------------------------------------------

*===============================================================================
* Set up
*===============================================================================
*--------------------------SET-UP & READ DIRECTORIES----------------------------
cd												// Current directory of code
do "[0.0] directories.do"

*===============================================================================
* Capital/Labour intensive industries (footnote 43)
*===============================================================================
import excel using "$data/WIOD_SEA_Nov16.xlsx", sheet("DATA") firstrow clear
set type float

qui foreach var in E F G H I J K L M N O P Q R S {
	replace `var' = "" if `var'=="NA"
}
qui destring, replace
renvarlab E-S, label prefix(y)
rename code IndustryCode 
rename description IndustryDescription

preserve
	use IndustryCode IndustryDescription CPA using "$data/NACE2_ISIC4_conversion.dta", clear
	gduplicates drop
	save "$temp/temp.dta", replace
restore
merge m:1 IndustryCode IndustryDescription using "$temp/temp.dta", keep(matched) nogen
erase "$temp/temp.dta"

* Keep relevant countries and industries
keep if country=="AUT" | country=="BEL" | country=="BGR" | country=="CZE" | country=="DEU" | ///
		country=="ESP" | country=="EST" | country=="FIN" | country=="FRA" | country=="HRV" | ///
		country=="HUN" | country=="ITA" | country=="NOR" | country=="POL" | country=="PRT" | ///
		country=="ROU" | country=="SVK" | country=="SVN" | country=="SWE" 
keep if inrange(CPA, 5, 23)

*Capital to labour ratio
keep if inlist(variable, "CAP", "EMPE") 		// CAP is Capital compensation (in millions of national currency); EMPE is Number of employees (thousands)
gegen sum = rowtotal(y2000-y2014)
drop y2000-y2014
gcollapse (sum) sum, by (variable CPA)
greshape wide sum, i(CPA) j(variable) string
gen KL=sumCAP/sumEMPE

* Labour-intensive industries
qui sum KL, det
tab CPA if KL < `r(p50)'
